/*
 * Decompiled with CFR 0.152.
 */
package ru.xe.kon.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import ru.xe.common.lang.Util;
import ru.xe.kon.core.ConstantData;
import ru.xe.kon.core.FileFactory;
import ru.xe.kon.core.KonFacade;
import ru.xe.kon.core.KonHttpFacade;
import ru.xe.kon.core.KonHttpFacadeImplMod;
import ru.xe.kon.core.KonUtils;
import ru.xe.kon.core.model.City;
import ru.xe.kon.core.model.DayInfo;

public class KonFacadeImplFile
implements KonFacade {
    FileFactory activity;
    KonHttpFacade konHttpFacade;
    String[] sysData = null;
    public static final String ADV_FILE_NAME = "ay1.data";
    public static final String DAY_INFO_TIME_FILE_NAME = "ay21.data";
    public static final String DAY_INFO_FILE_NAME = "ay2.data";
    public static final String SYS_DATA_FILE_NAME = "ay3.data";
    public static final String CITY_FILE_NAME = "ay4543.data";
    public static final boolean LIGHT = true;
    public static final String FILE_PREFIX = "ru.xe.kon.";
    public static boolean first = false;

    public KonFacadeImplFile(FileFactory activity) {
        this.activity = activity;
        this.konHttpFacade = new KonHttpFacadeImplMod();
    }

    public void saveData(String[] advertisings, DayInfo[] dayInfos, String emagencyInfo) {
        try {
            byte[] writeData;
            int i;
            RecordStore store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            int numRecords = store.getNumRecords();
            for (i = 0; i < advertisings.length; ++i) {
                writeData = KonFacadeImplFile.convertStringToByte(advertisings[i]);
                if (i >= numRecords) {
                    store.addRecord(writeData, 0, writeData.length);
                    continue;
                }
                store.setRecord(i + 1, writeData, 0, writeData.length);
            }
            for (i = numRecords - 1; i >= advertisings.length; --i) {
                store.deleteRecord(i + 1);
            }
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay21.data", (boolean)true);
            numRecords = store.getNumRecords();
            for (i = 0; i < dayInfos.length; ++i) {
                writeData = this.convertTimeToByte(dayInfos[i]);
                if (i >= numRecords) {
                    store.addRecord(writeData, 0, writeData.length);
                    continue;
                }
                store.setRecord(i + 1, writeData, 0, writeData.length);
            }
            for (i = numRecords - 1; i >= dayInfos.length; --i) {
                store.deleteRecord(i + 1);
            }
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay2.data", (boolean)true);
            numRecords = store.getNumRecords();
            for (i = 0; i < dayInfos.length; ++i) {
                writeData = KonFacadeImplFile.convertStringToByte(dayInfos[i].getInfo());
                if (i >= numRecords) {
                    store.addRecord(writeData, 0, writeData.length);
                    continue;
                }
                store.setRecord(i + 1, writeData, 0, writeData.length);
            }
            for (i = numRecords - 1; i >= dayInfos.length; --i) {
                store.deleteRecord(i + 1);
            }
            this.sysData = null;
            String[] systemData = this.getSysData();
            if (systemData == null || systemData.length == 0) {
                systemData = new String[10];
            }
            systemData[0] = emagencyInfo;
            this.saveSysData(systemData);
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
    }

    public static byte[] convertStringToByte(String s) {
        if (s == null) {
            return new byte[0];
        }
        ByteArrayOutputStream outB = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outB);
        try {
            out.writeUTF(s);
            out.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return outB.toByteArray();
    }

    private String convertByteToString(byte[] s) {
        if (Util.isEmpty(s)) {
            return null;
        }
        String result = "";
        ByteArrayInputStream inB = new ByteArrayInputStream(s);
        DataInputStream in = new DataInputStream(inB);
        try {
            result = in.readUTF();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String[] getSysData() {
        if (this.sysData == null) {
            RecordStore store = null;
            try {
                store = RecordStore.openRecordStore((String)"ru.xe.kon.ay3.data", (boolean)true);
            }
            catch (RecordStoreException ex) {
                return new String[10];
            }
            try {
                int length = store.getNumRecords();
                this.sysData = new String[10];
                for (int i = 0; i < length - 1; ++i) {
                    this.sysData[i] = this.convertByteToString(store.getRecord(i + 1));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception");
            }
            finally {
                try {
                    if (store != null) {
                        store.closeRecordStore();
                    }
                }
                catch (RecordStoreNotOpenException e) {
                }
                catch (RecordStoreException ex) {
                    return new String[10];
                }
            }
        }
        return this.sysData;
    }

    private void saveSysData() {
        this.saveSysData(this.sysData);
    }

    public void saveSysData(String[] data) {
        this.saveSysData(data, null);
    }

    public void saveSysData(String[] data, byte[] cityData) {
        RecordStore store = null;
        this.sysData = data;
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay3.data", (boolean)true);
            if (this.sysData != null) {
                int numRecords = store.getNumRecords();
                int n = this.sysData.length;
                for (int i = 0; i < n; ++i) {
                    byte[] writeData = KonFacadeImplFile.convertStringToByte(this.sysData[i]);
                    if (i >= numRecords) {
                        store.addRecord(writeData, 0, writeData.length);
                        continue;
                    }
                    store.setRecord(i + 1, writeData, 0, writeData.length);
                }
                if (cityData != null) {
                    if (n >= numRecords) {
                        store.addRecord(cityData, 0, cityData.length);
                    } else {
                        store.setRecord(n + 1, cityData, 0, cityData.length);
                    }
                    ++n;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
    }

    public String[] getAdvertisings() {
        String[] result;
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            int count = store.getNumRecords();
            result = new String[count];
            int i = -1;
            while (i + 1 < count) {
                String line;
                result[++i] = line = this.convertByteToString(store.getRecord(i + 1));
            }
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
        return result;
    }

    public DayInfo[] getDayInfos() {
        DayInfo[] result;
        DayInfo dayInfo = null;
        RecordStore store = null;
        RecordStore store1 = null;
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay21.data", (boolean)true);
            store1 = RecordStore.openRecordStore((String)"ru.xe.kon.ay2.data", (boolean)true);
            result = new DayInfo[store.getNumRecords()];
            for (int n = 1; n <= store.getNumRecords(); ++n) {
                dayInfo = new DayInfo();
                byte[] readedData = null;
                readedData = store.getRecord(n);
                this.convertByteToTime(readedData, dayInfo);
                readedData = null;
                if (n <= store1.getNumRecords()) {
                    readedData = store1.getRecord(n);
                }
                dayInfo.setInfo(this.convertByteToString(readedData));
                result[n - 1] = dayInfo;
            }
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
            try {
                if (store1 != null) {
                    store1.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
        return result;
    }

    public DayInfo getDayInfo(Integer day) {
        DayInfo result = null;
        RecordStore store = null;
        RecordStore store1 = null;
        try {
            int n = day != null ? day : 1;
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay21.data", (boolean)true);
            if (n > store.getNumRecords()) {
                DayInfo dayInfo = new DayInfo();
                return dayInfo;
            }
            store1 = RecordStore.openRecordStore((String)"ru.xe.kon.ay2.data", (boolean)true);
            result = new DayInfo();
            byte[] readedData = null;
            if (n <= store.getNumRecords()) {
                readedData = store.getRecord(n);
            }
            this.convertByteToTime(readedData, result);
            readedData = null;
            if (n <= store1.getNumRecords()) {
                readedData = store1.getRecord(n);
            }
            result.setInfo(this.convertByteToString(readedData));
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
            try {
                if (store1 != null) {
                    store1.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
        return result;
    }

    public String getEmagencyInfo() {
        String result = null;
        String[] systemData = this.getSysData();
        if (systemData != null) {
            result = systemData[0];
        }
        return result;
    }

    public void gettingDataFromServer(boolean monthBegin) {
        if (first) {
            return;
        }
        this.konHttpFacade.getDataAndSave(this.getSysData(), monthBegin);
    }

    private void appendDayInfo(DayInfo[] dayInfos) {
        int n = dayInfos.length;
        DayInfo[] oldDayInfos = this.getDayInfos();
        if (n > oldDayInfos.length) {
            n = oldDayInfos.length;
        }
        for (int i = 0; i < n; ++i) {
            if (oldDayInfos[i] == null) continue;
            dayInfos[i].setInfo(oldDayInfos[i].getInfo());
        }
    }

    public void initData(boolean gettingDataFromServer) {
        if (gettingDataFromServer) {
            this.initData();
        } else {
            this.saveData(ConstantData.getAdvertisingsFromSource(), ConstantData.getDayInfosFromSource(), ConstantData.getEmagencyInfo());
        }
    }

    public void initData() {
        String[] ads;
        String[] systemData = this.getSysData();
        if (systemData[2] == null) {
            if ((systemData = this.konHttpFacade.registration(systemData))[2] == null) {
                return;
            }
            this.saveSysData(systemData, this.konHttpFacade.getCitiesAndSave(systemData));
            first = true;
            return;
        }
        boolean dataLoaded = false;
        dataLoaded = systemData[5] == null ? false : "true".equals(systemData[5].trim().toLowerCase());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        int month = calendar.get(2);
        if (dataLoaded) {
            if (systemData[4] == null || systemData[3] == null) {
                dataLoaded = false;
            } else {
                int sysMonth;
                int sysYear;
                String currYear = systemData[4];
                String currMonth = systemData[3];
                if (Util.isEmpty(currYear)) {
                    currYear = "-1";
                }
                if (Util.isEmpty(currMonth)) {
                    currMonth = "-1";
                }
                try {
                    sysYear = Integer.parseInt(currYear);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("currYear = " + currYear);
                }
                try {
                    sysMonth = Integer.parseInt(currMonth);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("currMonth = " + currMonth);
                }
                if (year != sysYear || month != sysMonth) {
                    dataLoaded = false;
                }
            }
        }
        if (dataLoaded && ((ads = this.getAdvertisings()) == null || ads.length == 0)) {
            dataLoaded = false;
        }
        if (!dataLoaded) {
            systemData[4] = String.valueOf(year);
            systemData[3] = String.valueOf(month);
            systemData[5] = String.valueOf(dataLoaded);
            this.saveSysData(systemData);
            try {
                dataLoaded = true;
                this.gettingDataFromServer(true);
            }
            catch (Exception ex) {
                systemData = this.getSysData();
                systemData[5] = String.valueOf(false);
                this.saveSysData(systemData);
                throw new RuntimeException(ex.getMessage());
            }
            systemData = this.getSysData();
            systemData[5] = String.valueOf(true);
            this.saveSysData(systemData);
        }
    }

    private byte[] convertTimeToByte(DayInfo dayInfo) {
        if (dayInfo == null) {
            return new byte[0];
        }
        ByteArrayOutputStream outB = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outB);
        try {
            int i;
            Integer[] times = dayInfo.getHours();
            for (i = 0; i < 7; ++i) {
                out.writeInt(times[i]);
            }
            times = dayInfo.getMinutes();
            for (i = 0; i < 7; ++i) {
                out.writeInt(times[i]);
            }
            out.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return outB.toByteArray();
    }

    private void convertByteToTime(byte[] s, DayInfo dayInfo) {
        if (s == null || s.length == 0) {
            int i;
            Integer[] time = new Integer[7];
            for (i = 0; i < 7; ++i) {
                time[i] = new Integer(-1);
            }
            dayInfo.setHours(time);
            time = new Integer[7];
            for (i = 0; i < 7; ++i) {
                time[i] = new Integer(-1);
            }
            dayInfo.setMinutes(time);
            return;
        }
        ByteArrayInputStream inB = new ByteArrayInputStream(s);
        DataInputStream in = new DataInputStream(inB);
        try {
            int i;
            Integer[] time = new Integer[7];
            for (i = 0; i < 7; ++i) {
                time[i] = new Integer(in.readInt());
            }
            dayInfo.setHours(time);
            time = new Integer[7];
            for (i = 0; i < 7; ++i) {
                time[i] = new Integer(in.readInt());
            }
            dayInfo.setMinutes(time);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String[] getDaysNames() {
        int n = KonUtils.getDaysInCurrentMonth();
        String[] result = new String[n + 1];
        result[0] = "\u0414\u0435\u043d\u044c";
        for (int i = 0; i < n; ++i) {
            result[i + 1] = String.valueOf(i + 1);
        }
        return result;
    }

    public String[][] getFullTimeTable() {
        DayInfo[] dayInfos = this.getDayInfos();
        int n = dayInfos.length;
        String[][] result = new String[7][n + 1];
        result[0][0] = "\u0424\u0430\u0434\u0436\u0440";
        result[1][0] = "\u0412\u043e\u0441\u0445\u043e\u0434";
        result[2][0] = "\u0417\u0435\u043d\u0438\u0442";
        result[3][0] = "\u0417\u0443\u0445\u0440";
        result[4][0] = "\u0410\u0441\u0440";
        result[5][0] = "\u041c\u0430\u0433\u0440\u0438\u0431";
        result[6][0] = "\u0418\u0448\u0430";
        for (int i = 0; i < n; ++i) {
            Integer[] hours = dayInfos[i].getHours();
            Integer[] minutes = dayInfos[i].getMinutes();
            for (int j = 0; j < 7; ++j) {
                result[j][i + 1] = KonUtils.getTimeFormat(hours[j], minutes[j]);
            }
        }
        return result;
    }

    public City[] getCities() {
        RecordStore store = null;
        City[] result = null;
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay3.data", (boolean)true);
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
        try {
            int length = store.getNumRecords();
            result = this.convertByteToCities(store.getRecord(length));
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {
                return new City[0];
            }
        }
        return result;
    }

    private City convertByteToCity(byte[] s) {
        City result = null;
        if (s == null || s.length == 0) {
            return null;
        }
        ByteArrayInputStream inB = new ByteArrayInputStream(s);
        DataInputStream in = new DataInputStream(inB);
        try {
            result = new City();
            result.setId(in.readInt());
            result.setName(in.readUTF());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static byte[] convertCityToByte(City city) throws IOException {
        if (city == null) {
            return new byte[0];
        }
        ByteArrayOutputStream outB = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outB);
        out.writeInt(city.getId());
        out.writeUTF(city.getName());
        out.flush();
        return outB.toByteArray();
    }

    public void updateCities() {
        if (first) {
            return;
        }
        this.saveSysData(this.sysData, this.konHttpFacade.getCitiesAndSave(this.sysData));
    }

    private City[] convertByteToCities(byte[] s) {
        City[] result = null;
        if (s == null || s.length == 0) {
            return null;
        }
        ByteArrayInputStream inB = new ByteArrayInputStream(s);
        DataInputStream in = new DataInputStream(inB);
        try {
            int n = in.readInt();
            result = new City[n];
            for (int i = 0; i < n; ++i) {
                result[i] = new City(in.readInt(), in.readUTF());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

